/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.VWManagerUtil;
import filenet.vw.apps.taskman.integrator.VWPLCredentials;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWAuthItem;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VWWSWPSAdvancedPanel
extends VWTaskTabPanel
implements ActionListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private static final long serialVersionUID = 1L;
    private VWManagerNode m_node = null;
    private JList m_list = null;
    private DefaultListModel m_listModel = null;
    private VWToolbarBorder m_listBorder = null;
    private List<String> m_listPLRefs = null;
    private String ceuri = null;
    private String connectionPoint = null;
    private String username = null;
    private String pw = null;
    private String m_file = null;
    private static final String HELPPAGE = VWHelp.Help_Process_TaskManager + "cm_config_ws.htm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getPartnerlinkRefs(String ceuri, String cp, String username, String pw) {
        VWSession ses = null;
        ArrayList<String> partnerlinkRefs = new ArrayList<String>(2);
        partnerlinkRefs.add(VWResource.DefaultPartnerlinkRef);
        try {
            JVMSystemConstants.SetPrivilegedSystemProperty("filenet.vw.api.rpc.timeout", "200");
            ses = new VWSession();
            ses.setBootstrapCEURI(ceuri);
            ses.logon(username, pw, cp);
            String[] wcNames = ses.fetchWorkClassNames(true);
            if (wcNames != null) {
                for (String wc : wcNames) {
                    VWWorkflowDefinition wfDef = ses.fetchWorkflowDefinition(-1, wc, false);
                    try {
                        VWPartnerLinkDefinition[] pls = wfDef.getPartnerLinks();
                        if (pls == null) continue;
                        for (VWPartnerLinkDefinition pl : pls) {
                            String s = pl.getPartnerLinkRef();
                            if (s == null || s.trim().length() <= 0) continue;
                            partnerlinkRefs.add(s.trim());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (ses != null) {
                try {
                    ses.logoff();
                }
                catch (VWException e) {}
            }
            ses = null;
        }
        return partnerlinkRefs;
    }

    public VWWSWPSAdvancedPanel(VWManagerNode node) {
        this.m_node = node;
        VWManagerUtil m_util = new VWManagerUtil(0);
        try {
            VWAuthItem item = m_util.getDString(this.m_node.getOptions());
            this.username = item.getName();
            this.pw = item.getPassword();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.ceuri = this.m_node.getCEURI();
        this.connectionPoint = this.m_node.getConnectionPoint();
        this.m_file = this.m_node.getWPSFileName();
        this.initLayout();
        this.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void getListFromFile(String fileName, DefaultListModel l) {
        if (l == null) {
            return;
        }
        FileInputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = new FileInputStream(fileName);
            p.load(inStream);
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String options = p.getProperty(key);
                VWManagerUtil m_util = new VWManagerUtil(0);
                VWAuthItem item = m_util.getDString(options);
                l.addElement(new WPSITEM(key.equals("-1") ? VWResource.DefaultPartnerlinkRef : key, item.getName(), item.getPassword()));
            }
        }
        catch (Throwable t) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeListToFile(String fileName, DefaultListModel l) {
        if (l == null) {
            return;
        }
        FileOutputStream outStream = null;
        try {
            Properties p = new Properties();
            int n = l.size();
            for (int i = 0; i < n; ++i) {
                WPSITEM item = (WPSITEM)l.get(i);
                VWManagerUtil m_util = new VWManagerUtil(0);
                String key = item.itemName;
                if (key.equals(VWResource.DefaultPartnerlinkRef)) {
                    key = "-1";
                }
                p.setProperty(key, m_util.getEString(item.user, item.pw));
            }
            outStream = new FileOutputStream(fileName);
            p.store(outStream, "");
        }
        catch (Throwable t) {
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void initLayout() {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_listBorder = new VWToolbarBorder(VWResource.PartnerlinkRefs, 272629808);
        this.m_listBorder.addToolbarBorderActionNotifier(this);
        JPanel clientPanel = this.m_listBorder.getClientPanel();
        clientPanel.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        VWWSWPSAdvancedPanel.getListFromFile(this.m_file, this.m_listModel);
        this.m_list = new JList(this.m_listModel);
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(this);
        listPanel.add((Component)this.m_list, "Center");
        clientPanel.add((Component)new JScrollPane(listPanel, 20, 30), "Center");
        c.fill = 1;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.m_listBorder, c);
    }

    public void updateState() {
        if (!this.m_node.isStarted()) {
            int index = this.m_list.getSelectedIndex();
            boolean itemSelected = index != -1;
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 16));
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 0x400000));
            if (itemSelected) {
                this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 0x10000000));
                this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 1, 32));
            }
            this.m_list.setEnabled(true);
        } else {
            this.m_listBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_listBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_list.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.updateState();
    }

    @Override
    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int id = event.getID();
            switch (id) {
                case 0x400000: {
                    if (this.m_listPLRefs != null) {
                        this.m_listPLRefs.clear();
                    }
                    this.m_listPLRefs = VWWSWPSAdvancedPanel.getPartnerlinkRefs(this.ceuri, this.connectionPoint, this.username, this.pw);
                    this.updateState();
                    break;
                }
                case 16: {
                    if (this.m_listPLRefs == null) {
                        this.m_listPLRefs = VWWSWPSAdvancedPanel.getPartnerlinkRefs(this.ceuri, this.connectionPoint, this.username, this.pw);
                    }
                    VWPLCredentials credDlg = VWPLCredentials.getInstance(this.m_listPLRefs, VWResource.PartnerlinkRef);
                    credDlg.show();
                    if (!credDlg.getIsCanceled()) {
                        String selPLRef = credDlg.getItem();
                        int selIndex = -1;
                        for (int i = 0; i < this.m_listModel.size(); ++i) {
                            WPSITEM item = (WPSITEM)this.m_listModel.get(i);
                            if (!item.itemName.equals(selPLRef)) continue;
                            selIndex = i;
                            break;
                        }
                        if (selIndex == -1) {
                            this.m_listModel.addElement(new WPSITEM(credDlg.getItem(), credDlg.getUsername(), credDlg.getPassword()));
                        } else {
                            WPSITEM item = (WPSITEM)this.m_listModel.get(selIndex);
                            item.user = credDlg.getUsername();
                            item.pw = credDlg.getPassword();
                            this.m_list.updateUI();
                        }
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                    break;
                }
                case 0x10000000: {
                    int index = this.m_list.getSelectedIndex();
                    this.m_listModel.remove(index);
                    if (index < this.m_listModel.size()) {
                        this.m_list.setSelectedIndex(index);
                    } else if (this.m_listModel.size() > 0) {
                        this.m_list.setSelectedIndex(index - 1);
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                    break;
                }
                case 32: {
                    WPSITEM item = (WPSITEM)this.m_list.getSelectedValue();
                    VWPLCredentials dlg = VWPLCredentials.getInstance(item.itemName, item.user, item.pw, VWResource.PartnerlinkRef);
                    dlg.show();
                    if (!dlg.getIsCanceled()) {
                        item.user = dlg.getUsername();
                        item.pw = dlg.getPassword();
                        this.m_list.updateUI();
                    }
                    this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    protected void applyProperties() {
        VWWSWPSAdvancedPanel.writeListToFile(this.m_file, this.m_listModel);
    }

    @Override
    public String getHelpPage() {
        return HELPPAGE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected static class WPSITEM {
        String itemName;
        String user;
        String pw;

        protected WPSITEM(String a, String b, String c) {
            this.itemName = a;
            this.user = b;
            this.pw = c;
        }

        public String toString() {
            return this.itemName + " [" + this.user + "]";
        }
    }
}

